//
//  Chap7.h
//  Sinc
//
//  Created by Y m on 2018/03/30.
//  Copyright  2018N Y m. All rights reserved.
//

#ifndef Chap7_h
#define Chap7_h
/*-------------------------------------------------*/
/*mVnHayterzCLee-SpurrierzCWilliamsz@@  */
/*-------------------------------------------------*/
// n֐̗Lsinc
double FInterpolation(double t,int n,double t0,double h,double sg,double *g){
    /*D1CDF,D2CDF,D3CDFsincԊ֐F_n(t)F(t)̌vZ*/
    /*ߎ䔼nCW{__t0CW{_ԊuhCW΍sgCԌWg[2n+1]*/
    int i;
    double Fn,ts[300];
    for(i=-n;i<=n;i++)ts[i+n]=t0+i*h;//W{_̐
    Fn=PhiCDF(sg,t-t0);//Kz̕z֐̍
    for(i=0;i<=2*n;i++)Fn+=g[i]*snc(h,ts[i],t);//sincԍZ
    return Fn;
};

//Qߕz
double D1CDF(double t,int k){/*Hayterz̑Qߕz*/
#include "HayterData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double D2CDF(double t,int k){/*Lee-Spurrierz̑Qߕz*/
#include "LeeSpurrierData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double D3CDF(double t,int k){/*Williamsz̑Qߕz*/
#include "WilliamsData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double TD1CDF(double t,int k,int m){/*Hayterz̑Qߕz*/
    if(m==-1) return D1CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D1CDF,t,k,m);
};
double TD2CDF(double t,int k,int m){/*Lee-Spurrierz*/
    if(m==-1) return D2CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D2CDF,t,k,m);
};
double TD3CDF(double t,int k,int m){/*Williamsz*/
    if(m==-1) return D3CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D3CDF,t,k,m);
};

//100%_
double td1Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD1CDF,k,m,al);
};
double td2Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD2CDF,k,m,al);
};
double td3Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD3CDF,k,m,al);
};
double d1Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD1CDF,k,-1,al);
};
double d2Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD2CDF,k,-1,al);
};
double d3Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD3CDF,k,-1,al);
};

//\֐(T1^j
double** td1Tab(int k,int m,double al){/*Hayter td1Fun(k,m,al)T1^2\z̏o */
    return MakeTabT1td(td1Fun,k,m,al);
};
double** td2Tab(int k,int m,double al){/*Lee-Spurrier td2Fun(k,m,al)T1^2\z̏o */
    return MakeTabT1td(td2Fun,k,m,al);
};
double* td3Tab(int k,int m,double al){/*Williams td3Fun(k,m,al)T3^1\z̏o */
    return MakeTabT3td(td3Fun,k,m,al);
};
double** d1Tab(int k,double al){/*Hayter d1Fun(k,al)T1^2\z̏o */
    return MakeTabT1td(td1Fun,k,-1,al);
};
double** d2Tab(int k,double al){/*Lee-Spurrier d2Fun(k,al)T1^2\z̏o */
    return MakeTabT1td(td2Fun,k,-1,al);
};
double* d3Tab(int k,double al){/*Williams d3Fun(k,al)T3^1\z̏o */
    return MakeTabT3td(td3Fun,k,-1,al);
};

#endif /* Chap7_h */
